/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineEndToEnd.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "cApplication.h"
#include "cLine.h"

//	Creates a line using the end points of the given lines and 
//	returns the line created.After creation the line is AutoConstrained
//	like the way it is handled at UI level.

HRESULT CreateLineEndToEnd(ILine *line1, ILine *line2, ILine **newLine1)
{

	START_METHOD("CreateLineEndToEnd")

	HRESULT status = CONV_SUCCESS;
	
	// Get the end point of the first line
	IPoint *endPoint1 = NULL;
	status = line1->GetEndPoint(&endPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the end point of the second line
	IPoint *endPoint2 = NULL;
	status = line2->GetEndPoint(&endPoint2);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(endPoint1, endPoint2, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineEndToEnd")
}
